package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Naxas_R_bumper extends Bumper
{
	public Naxas_R_bumper( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Naxas rear bumper";

		value = 2000;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_04.naxas:0x000000EAr, "RL blinker", actcolor, optical, power );
			addPart( cars.cat_04.naxas:0x000000ECr, "RR blinker", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_04.naxas:0x000000EAr, "RL blinker", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.naxas:0x000000ECr, "RR blinker", actcolor, optical, power );
		}
	}
}
